/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.api;

import frc.emul.api.IFramework;
import frc.emul.api.IFrameworkEvent;
import frc.emul.api.IFrameworkListener;
import frc.emul.api.IFrameworkPart;
import java.util.ArrayList;
import java.util.List;

public final class Framework
implements IFramework {
    private static final Framework SINGLETON = new Framework();
    private static boolean TRACE;
    private final List<IFrameworkListener> listeners = new ArrayList<IFrameworkListener>();
    private final List<IFrameworkPart> parts = new ArrayList<IFrameworkPart>();

    private Framework() {
    }

    public static final Framework getDefault() {
        return SINGLETON;
    }

    public static final void setTraceActivated(boolean bl) {
        TRACE = bl;
    }

    public synchronized void addFrameworkListener(IFrameworkListener iFrameworkListener) {
        this.listeners.add(iFrameworkListener);
    }

    public synchronized void removeFrameworkListener(IFrameworkListener iFrameworkListener) {
        this.listeners.remove(iFrameworkListener);
    }

    public IFrameworkPart getPart(String string) {
        for (IFrameworkPart iFrameworkPart : this.parts) {
            if (!string.equals(iFrameworkPart.getPartID())) continue;
            return iFrameworkPart;
        }
        return null;
    }

    public IFrameworkPart.State getState(String string) {
        for (IFrameworkPart iFrameworkPart : this.parts) {
            if (!string.equals(iFrameworkPart.getPartID())) continue;
            return iFrameworkPart.getPartState();
        }
        return null;
    }

    public synchronized void actionPerformed(final IFrameworkEvent.Action action, final IFrameworkPart iFrameworkPart) {
        if (TRACE) {
            System.out.println("[Framework] " + (Object)((Object)action) + " event for part : " + this.toString(iFrameworkPart));
        }
        if (IFrameworkEvent.Action.PART_DISCARDED == action) {
            if (TRACE) {
                System.out.println("[Framework] unregistering part : " + this.toString(iFrameworkPart) + "'");
            }
            this.parts.remove(iFrameworkPart);
        } else if (!this.parts.contains(iFrameworkPart)) {
            if (TRACE) {
                System.out.println("[Framework] registering new part : " + this.toString(iFrameworkPart) + "'");
            }
            this.checkForDuplicates(iFrameworkPart);
            this.parts.add(iFrameworkPart);
        }
        IFrameworkEvent iFrameworkEvent = new IFrameworkEvent(){

            public IFramework getFramework() {
                return Framework.this;
            }

            public IFrameworkPart getPart() {
                return iFrameworkPart;
            }

            public IFrameworkEvent.Action getAction() {
                return action;
            }
        };
        for (IFrameworkListener iFrameworkListener : this.listeners) {
            iFrameworkListener.actionPerformed(iFrameworkEvent);
        }
    }

    private final void checkForDuplicates(IFrameworkPart iFrameworkPart) {
        IFrameworkPart iFrameworkPart2 = this.getPart(iFrameworkPart.getPartID());
        if (iFrameworkPart2 != null && iFrameworkPart != iFrameworkPart2) {
            String string = "Duplicate parts detected : [" + this.toString(iFrameworkPart2) + "] and [" + this.toString(iFrameworkPart) + "]";
            throw new IllegalStateException(string);
        }
    }

    private final String toString(IFrameworkPart iFrameworkPart) {
        return "ID=" + iFrameworkPart.getPartID() + " name='" + iFrameworkPart.getPartID() + "' state=" + (Object)((Object)iFrameworkPart.getPartState());
    }
}

